<?php

use App\Http\Controllers\MobilController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\UserAuthController;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Models\Role;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::resource('products', ProductController::class);

Route::get('login', [UserAuthController::class, 'login']);

Route::get('register', [UserAuthController::class, 'register']);

Route::post('create', [UserAuthController::class, 'create'])->name('auth.create');

Route::post('check', [UserAuthController::class, 'check'])->name('auth.check');

Route::get('logout', [UserAuthController::class, 'logout']);

// Route::get('/', function () {
//     $role = Role::first();
//     $role->givePermissionTo('manage-car', 'manage-info');
// });

Route::get('/', 'App\Http\Controllers\HomeController@index');

Route::get('/home', 'App\Http\Controllers\HomeController@index');

Route::view('daftarmobil', 'daftarmobil');

Route::get('daftarmobil', [MobilController::class, 'index']);

Route::view('information', 'information');

Route::post('/pembayaran', function (){
    return view('pembayaran');
});




